﻿using System;
using System.Collections.Generic;
using System.Linq;

using VIRP.EFR.BO;

namespace VIRP.EFR.DAL
{
    public class RelatedDiagnosticsDB : DBUtils
    {
        public IEnumerable<RelatedDiagnosticsView> GetRelatedDiagnosticsForPatient(
            string CURRENT_USER,
            int CURRENT_REGISTRY_ID,
            int PATIENT_ID,
            string SORT_COLUMN)
        {
            List<RelatedDiagnosticsView> objReturn = null;

            try
            {
                using (EFRDBDataContext dbContext = GetEfrDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);

                    objReturn = dbContext
                        .usp_GetRelatedDiagnosticsForPatient(
                            CURRENT_USER,
                            CURRENT_REGISTRY_ID,
                            PATIENT_ID)
                        .ToList();

                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), string.Empty, 0);
                throw ex;
            }

            return objReturn;
        }
    }
}
